<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CorrecttionData extends Model 
{

    protected $table = 'correction_data';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('data_level', 'data_temp', 'data_pressure', 'tank_id');
    protected $visible = array('data_level', 'data_temp', 'data_pressure', 'tank_id');

    public function tank()
    {
        return $this->belongsTo('Tank', 'tank_id');
    }

}